(function ($) {
  "use strict";




  /*--------------------------------------------------------------
    RegisterPlugin, ScrollTrigger, SplitText
  --------------------------------------------------------------*/
  gsap.registerPlugin(ScrollTrigger, SplitText);
  gsap.config({
    nullTargetWarn: false,
    trialWarn: false
  });



  // Preloader
  $('#preloader').delay(200).fadeOut('slow');


  // AOS Animation
  if ($("[data-aos]").length) {
    AOS.init({
      duration: '1200',
      disable: 'false',
      easing: 'ease',
      mirror: true
    });
  }


  // ===Datepicker===
  if ($("#datepicker").length) {
    $("#datepicker").datepicker();
  }


  /*--------------------------------------------------------------
    FullHeight
  --------------------------------------------------------------*/
  function fullHeight() {
    $('.full-height').css("height", $(window).height());
  }




  function thmSwiperInit() {
    // swiper slider
    if ($(".thm-swiper__slider").length) {
      $(".thm-swiper__slider").each(function () {
        let elm = $(this);
        let options = elm.data('swiper-options');
        let thmSwiperSlider = new Swiper(elm, options);
      });
    }

  }



  // Services One Carousel
  if ($(".services-one__carousel").length > 0) {
    const swiper = new Swiper('.services-one__carousel', {
      "slidesPerView": 1,
      "spaceBetween": 0,
      "speed": 600,
      "loop": true,
      "pagination": {
        "el": "#swiper-dot-style1",
        "type": "bullets",
        "clickable": true
      },

      "navigation": {
        "nextEl": "#swiper-button-prev1",
        "prevEl": "#swiper-button-next1"
      },
      "autoplay": {
        "delay": 6000
      },
      "breakpoints": {
        "0": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "375": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "575": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "768": {
          "spaceBetween": 30,
          "slidesPerView": 2
        },
        "992": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "1200": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "1320": {
          "spaceBetween": 30,
          "slidesPerView": 3
        }
      },
    });
  }

  if ($(".marquee_mode-1").length) {
    $('.marquee_mode-1').marquee({
      speed: 30,
      gap: 0,
      delayBeforeStart: 0,
      direction: 'left',
      duplicated: true,
      pauseOnHover: true,
      startVisible: true,
    });
  }

  if ($(".marquee_mode-2").length) {
    $('.marquee_mode-2').marquee({
      speed: 30,
      gap: 20,
      delayBeforeStart: 0,
      direction: 'left',
      duplicated: true,
      pauseOnHover: true,
      startVisible: true,
    });
  }
  if ($(".marquee_mode-3").length) {
    $('.marquee_mode-3').marquee({
      speed: 30,
      gap: 30,
      delayBeforeStart: 0,
      direction: 'left',
      duplicated: true,
      pauseOnHover: true,
      startVisible: true,
    });
  }



  // Brand One Carousel
  if ($(".brand-one__carousel").length > 0) {
    const swiper = new Swiper('.brand-one__carousel', {
      "slidesPerView": 5,
      "spaceBetween": 0,
      "speed": 600,
      "loop": true,
      "pagination": {
        "el": "#swiper-dot-style1",
        "type": "bullets",
        "clickable": true
      },

      "navigation": {
        "nextEl": "#swiper-button-prev1",
        "prevEl": "#swiper-button-next1"
      },
      "autoplay": {
        "delay": 8000
      },
      "breakpoints": {
        "0": {
          "spaceBetween": 0,
          "slidesPerView": 1
        },
        "375": {
          "spaceBetween": 0,
          "slidesPerView": 1
        },
        "575": {
          "spaceBetween": 0,
          "slidesPerView": 1
        },
        "768": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "992": {
          "spaceBetween": 30,
          "slidesPerView": 4
        },
        "1200": {
          "spaceBetween": 30,
          "slidesPerView": 5
        },
        "1320": {
          "spaceBetween": 30,
          "slidesPerView": 5
        }
      },
    });
  }


  // Project One
  if ($(".project-one__carousel").length > 0) {
    const swiper = new Swiper('.project-one__carousel', {
      "slidesPerView": 3,
      "spaceBetween": 0,
      "speed": 600,
      "loop": true,
      "pagination": {
        "el": ".swiper-dot-style1",
        "type": "bullets",
        "clickable": true
      },

      "navigation": {
        "nextEl": ".swiper-button-prev1",
        "prevEl": ".swiper-button-next1"
      },
      "autoplay": {
        "delay": 6000
      },
      "breakpoints": {
        "0": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "375": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "575": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "768": {
          "spaceBetween": 30,
          "slidesPerView": 2
        },
        "992": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "1200": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "1320": {
          "spaceBetween": 30,
          "slidesPerView": 3
        }
      },
    });
  }

  // Testimonial One
  if ($(".testimonial-one__carousel").length > 0) {
    const swiper = new Swiper('.testimonial-one__carousel', {
      "slidesPerView": 3,
      "spaceBetween": 0,
      "speed": 600,
      "loop": true,
      "pagination": {
        "el": ".swiper-dot-style1",
        "type": "bullets",
        "clickable": true
      },

      "navigation": {
        "nextEl": ".swiper-button-prev1",
        "prevEl": ".swiper-button-next1"
      },
      "autoplay": {
        "delay": 6000
      },
      "breakpoints": {
        "0": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "375": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "575": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "768": {
          "spaceBetween": 30,
          "slidesPerView": 2
        },
        "992": {
          "spaceBetween": 30,
          "slidesPerView": 2
        },
        "1200": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "1320": {
          "spaceBetween": 30,
          "slidesPerView": 3
        }
      },
    });
  }

  // Gallery One
  if ($(".gallery-one__carousel").length > 0) {
    const swiper = new Swiper('.gallery-one__carousel', {
      "slidesPerView": 6,
      "spaceBetween": 0,
      "speed": 2000,
      "loop": true,
      "pagination": {
        "el": ".swiper-dot-style1",
        "type": "bullets",
        "clickable": true
      },

      "navigation": {
        "nextEl": ".swiper-button-prev1",
        "prevEl": ".swiper-button-next1"
      },
      "autoplay": {
        "delay": 8000
      },
      "breakpoints": {
        "0": {
          "spaceBetween": 0,
          "slidesPerView": 1
        },
        "375": {
          "spaceBetween": 0,
          "slidesPerView": 1
        },
        "575": {
          "spaceBetween": 5,
          "slidesPerView": 2
        },
        "768": {
          "spaceBetween": 5,
          "slidesPerView": 3
        },
        "992": {
          "spaceBetween": 5,
          "slidesPerView": 4
        },
        "1200": {
          "spaceBetween": 5,
          "slidesPerView": 5
        },
        "1320": {
          "spaceBetween": 5,
          "slidesPerView": 6
        }
      },
    });
  }

  //Project Two Carousel
  if ($(".project-two__carousel").length) {
    $(".project-two__carousel").owlCarousel({
      loop: true,
      margin: 30,
      nav: false,
      dots: true,
      smartSpeed: 500,
      autoplay: true,
      autoplayTimeout: 7000,
      navText: [
        '<span class="icon-arrow-right"></span>',
        '<span class="icon-arrow-right"></span>',
      ],
      responsive: {
        0: {
          items: 1,
        },
        768: {
          items: 2,
        },
        992: {
          items: 3,
        },
        1320: {
          items: 4,
        },
      },
    });
  }

  // Testimonial Two
  if ($(".testimonial-two__carousel").length > 0) {
    const swiper = new Swiper('.testimonial-two__carousel', {
      "slidesPerView": 3,
      "spaceBetween": 0,
      "speed": 600,
      "loop": true,
      "pagination": {
        "el": ".swiper-dot-style1",
        "type": "bullets",
        "clickable": true
      },

      "navigation": {
        "nextEl": ".swiper-button-prev1",
        "prevEl": ".swiper-button-next1"
      },
      "autoplay": {
        "delay": 6000
      },
      "breakpoints": {
        "0": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "375": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "575": {
          "spaceBetween": 20,
          "slidesPerView": 1
        },
        "768": {
          "spaceBetween": 30,
          "slidesPerView": 2
        },
        "992": {
          "spaceBetween": 20,
          "slidesPerView": 2
        },
        "1200": {
          "spaceBetween": 30,
          "slidesPerView": 3
        },
        "1320": {
          "spaceBetween": 30,
          "slidesPerView": 3
        }
      },
    });
  }

  //Services Three Carousel
  if ($(".service-three__carousel").length) {
    $(".service-three__carousel").owlCarousel({
      loop: true,
      margin: 15,
      nav: false,
      dots: true,
      smartSpeed: 500,
      autoplay: true,
      autoplayTimeout: 7000,
      navText: [
        '<span class="icon-left-arrow"></span>',
        '<span class="icon-right-arrow"></span>',
      ],
      responsive: {
        0: {
          items: 1,
        },
        768: {
          items: 2,
        },
        992: {
          items: 2,
        },
        1200: {
          items: 3,
        },
        1320: {
          items: 3,
        },
      },
    });
  }


  //Feature Two Carousel
  if ($(".feature-two__carousel").length) {
    $(".feature-two__carousel").owlCarousel({
      loop: true,
      margin: 30,
      nav: false,
      dots: false,
      smartSpeed: 500,
      autoplay: true,
      autoplayTimeout: 7000,
      navText: [
        '<span class="icon-left-arrow"></span>',
        '<span class="icon-right-arrow"></span>',
      ],
      responsive: {
        0: {
          items: 1,
        },
        768: {
          items: 2,
        },
        992: {
          items: 3,
        },
        1200: {
          items: 4,
        },
        1320: {
          items: 4,
        },
      },
    });
  }


  //Services Three Tab Tabs
  if ($('.service-three-tabs-box').length) {
    $('.service-three-tabs-box .service-three-tab-btns .p-tab-btn').on('click', function (e) {
      e.preventDefault();
      var target = $($(this).attr('data-tab'));

      if ($(target).hasClass('actve-tab')) {
        return false;
      } else {
        $('.service-three-tabs-box .service-three-tab-btns .p-tab-btn').removeClass('active-btn');
        $(this).addClass('active-btn');
        $('.service-three-tabs-box .p-tabs-content .p-tab').removeClass('active-tab');
        $(target).addClass('active-tab');
      }
    });
  }





  //Image Reveal Animation
  if ($(".reveal").length) {
    gsap.registerPlugin(ScrollTrigger);
    let revealContainers = document.querySelectorAll(".reveal");
    revealContainers.forEach((container) => {
      let image = container.querySelector("img");
      let tl = gsap.timeline({
        scrollTrigger: {
          trigger: container,
          toggleActions: "play none none none",
        },
      });
      tl.set(container, {
        autoAlpha: 1,
      });
      tl.from(container, 1.5, {
        xPercent: -100,
        ease: Power2.out,
      });
      tl.from(image, 1.5, {
        xPercent: 100,
        scale: 1.3,
        delay: -1.5,
        ease: Power2.out,
      });
    });
  }




  // custom coursor
  if ($(".custom-cursor").length) {

    var cursor = document.querySelector('.custom-cursor__cursor');
    var cursorinner = document.querySelector('.custom-cursor__cursor-two');
    var a = document.querySelectorAll('a');

    document.addEventListener('mousemove', function (e) {
      var x = e.clientX;
      var y = e.clientY;
      cursor.style.transform = `translate3d(calc(${e.clientX}px - 50%), calc(${e.clientY}px - 50%), 0)`
    });

    document.addEventListener('mousemove', function (e) {
      var x = e.clientX;
      var y = e.clientY;
      cursorinner.style.left = x + 'px';
      cursorinner.style.top = y + 'px';
    });

    document.addEventListener('mousedown', function () {
      cursor.classList.add('click');
      cursorinner.classList.add('custom-cursor__innerhover')
    });

    document.addEventListener('mouseup', function () {
      cursor.classList.remove('click')
      cursorinner.classList.remove('custom-cursor__innerhover')
    });

    a.forEach(item => {
      item.addEventListener('mouseover', () => {
        cursor.classList.add('custom-cursor__hover');
      });
      item.addEventListener('mouseleave', () => {
        cursor.classList.remove('custom-cursor__hover');
      });
    })
  }








  //Progress Count Bar
  if ($(".count-bar").length) {
    $(".count-bar").appear(
      function () {
        var el = $(this);
        var percent = el.data("percent");
        $(el).css("width", percent).addClass("counted");
      }, {
        accY: -50
      }
    );
  }



  //Fact Counter + Text Count
  if ($(".count-box").length) {
    $(".count-box").appear(
      function () {
        var $t = $(this),
          n = $t.find(".count-text").attr("data-stop"),
          r = parseInt($t.find(".count-text").attr("data-speed"), 10);

        if (!$t.hasClass("counted")) {
          $t.addClass("counted");
          $({
            countNum: $t.find(".count-text").text()
          }).animate({
            countNum: n
          }, {
            duration: r,
            easing: "linear",
            step: function () {
              $t.find(".count-text").text(Math.floor(this.countNum));
            },
            complete: function () {
              $t.find(".count-text").text(this.countNum);
            }
          });
        }
      }, {
        accY: 0
      }
    );
  }




  // Accrodion
  if ($(".accrodion-grp").length) {
    var accrodionGrp = $(".accrodion-grp");
    accrodionGrp.each(function () {
      var accrodionName = $(this).data("grp-name");
      var Self = $(this);
      var accordion = Self.find(".accrodion");
      Self.addClass(accrodionName);
      Self.find(".accrodion .accrodion-content").hide();
      Self.find(".accrodion.active").find(".accrodion-content").show();
      accordion.each(function () {
        $(this)
          .find(".accrodion-title")
          .on("click", function () {
            if ($(this).parent().hasClass("active") === false) {
              $(".accrodion-grp." + accrodionName)
                .find(".accrodion")
                .removeClass("active");
              $(".accrodion-grp." + accrodionName)
                .find(".accrodion")
                .find(".accrodion-content")
                .slideUp();
              $(this).parent().addClass("active");
              $(this).parent().find(".accrodion-content").slideDown();
            }
          });
      });
    });
  }



  $(".contact-form-validated").each(function () {
    $(this).validate({
      rules: {
        email: {
          required: true,
          email: true
        }
      },
      submitHandler: function (form) {
        $.post(
          $(form).attr("action"),
          $(form).serialize(),
          function (response) {
            $(form).find(".result").html(response);
            $(form).find('input[type="text"], input[type="email"], textarea').val("");
          }
        );
        return false;
      }
    });
  });







  if ($(".video-popup").length) {
    $(".video-popup").magnificPopup({
      type: "iframe",
      mainClass: "mfp-fade",
      removalDelay: 160,
      preloader: true,

      fixedContentPos: false
    });
  }

  if ($(".img-popup").length) {
    var groups = {};
    $(".img-popup").each(function () {
      var id = parseInt($(this).attr("data-group"), 10);

      if (!groups[id]) {
        groups[id] = [];
      }

      groups[id].push(this);
    });

    $.each(groups, function () {
      $(this).magnificPopup({
        type: "image",
        closeOnContentClick: true,
        closeBtnInside: false,
        gallery: {
          enabled: true
        }
      });
    });
  }



  //Chat Popup
  if ($('#chat-popup').length) {

    //Show Popup
    $('.chat-toggler').on('click', function () {
      $('#chat-popup').addClass('popup-visible');
    });
    $(document).keydown(function (e) {
      if (e.keyCode === 27) {
        $('#chat-popup').removeClass('popup-visible');
      }
    });
    //Hide Popup
    $('.close-chat,.chat-popup .overlay-layer').on('click', function () {
      $('#chat-popup').removeClass('popup-visible');
    });
  }




  function dynamicCurrentMenuClass(selector) {
    let fileName = window.location.pathname.split("/").pop() || "index.html";

    // Remove all existing 'current' classes
    selector.find("li").removeClass("current");

    // Loop through all <li> elements and match with href
    selector.find("li").each(function () {
      let anchor = $(this).find("a").first();
      if (anchor.length && anchor.attr("href") === fileName) {
        $(this).addClass("current");

        // Traverse all parent <li> and add 'current'
        $(this).parents("li").addClass("current");
      }
    });

    // Default: if no current found, highlight the Home
    if (!selector.find("li.current").length) {
      selector.children("li").first().addClass("current");
    }
  }

  // Initialize
  if ($(".main-menu__list").length) {
    let mainNavUL = $(".main-menu__list");
    dynamicCurrentMenuClass(mainNavUL);
  }




  if ($(".main-menu__list").length && $(".mobile-nav__container").length) {
    let navContent = document.querySelector(".main-menu__list").outerHTML;
    let mobileNavContainer = document.querySelector(".mobile-nav__container");
    mobileNavContainer.innerHTML = navContent;
  }
  if ($(".sticky-header__content").length) {
    let navContent = document.querySelector(".main-menu").innerHTML;
    let mobileNavContainer = document.querySelector(".sticky-header__content");
    mobileNavContainer.innerHTML = navContent;
  }

  if ($(".mobile-nav__container .main-menu__list").length) {
    let dropdownAnchor = $(
      ".mobile-nav__container .main-menu__list .dropdown > a"
    );
    dropdownAnchor.each(function () {
      let self = $(this);
      let toggleBtn = document.createElement("BUTTON");
      toggleBtn.setAttribute("aria-label", "dropdown toggler");
      toggleBtn.innerHTML = "<i class='fa fa-angle-down'></i>";
      self.append(function () {
        return toggleBtn;
      });
      self.find("button").on("click", function (e) {
        e.preventDefault();
        let self = $(this);
        self.toggleClass("expanded");
        self.parent().toggleClass("expanded");
        self.parent().parent().children("ul").slideToggle();
      });
    });
  }

  if ($(".mobile-nav__toggler").length) {
    $(".mobile-nav__toggler").on("click", function (e) {
      e.preventDefault();
      $(".mobile-nav__wrapper").toggleClass("expanded");
      $("body").toggleClass("locked");
    });
  }




  //Header Search
  if ($('.searcher-toggler-box').length) {
    $('.searcher-toggler-box').on('click', function (e) {
      e.preventDefault();
      $('body').addClass('search-active');
    });


    $('.close-search').on('click', function () {
      $('body').removeClass('search-active');
    });


    $('.search-popup .color-layer').on('click', function () {
      $('body').removeClass('search-active');
    });

  }




  if ($(".wow").length) {
    var wow = new WOW({
      boxClass: "wow", // animated element css class (default is wow)
      animateClass: "animated", // animation css class (default is animated)
      mobile: true, // trigger animations on mobile devices (default is true)
      live: true // act on asynchronously loaded content (default is true)
    });
    wow.init();
  }






  if ($(".tabs-box").length) {
    $(".tabs-box .tab-buttons .tab-btn").on("click", function (e) {
      e.preventDefault();
      var target = $($(this).attr("data-tab"));

      if ($(target).is(":visible")) {
        return false;
      } else {
        target
          .parents(".tabs-box")
          .find(".tab-buttons")
          .find(".tab-btn")
          .removeClass("active-btn");
        $(this).addClass("active-btn");
        target
          .parents(".tabs-box")
          .find(".tabs-content")
          .find(".tab")
          .fadeOut(0);
        target
          .parents(".tabs-box")
          .find(".tabs-content")
          .find(".tab")
          .removeClass("active-tab");
        $(target).fadeIn(300);
        $(target).addClass("active-tab");
      }
    });
  }


  if ($(".odometer").length) {
    var odo = $(".odometer");
    odo.each(function () {
      $(this).appear(function () {
        var countNumber = $(this).attr("data-count");
        $(this).html(countNumber);
      });
    });
  }









  // ===Portfolio===
  function projectMasonaryLayout() {
    if ($(".masonary-layout").length) {
      $(".masonary-layout").isotope({
        layoutMode: "masonry"
      });
    }
    if ($(".post-filter").length) {
      $(".post-filter li")
        .children(".filter-text")
        .on("click", function () {
          var Self = $(this);
          var selector = Self.parent().attr("data-filter");
          $(".post-filter li").removeClass("active");
          Self.parent().addClass("active");
          $(".filter-layout").isotope({
            filter: selector,
            animationOptions: {
              duration: 500,
              easing: "linear",
              queue: false
            }
          });
          return false;
        });
    }

    if ($(".post-filter.has-dynamic-filters-counter").length) {
      // var allItem = $('.single-filter-item').length;
      var activeFilterItem = $(".post-filter.has-dynamic-filters-counter").find(
        "li"
      );
      activeFilterItem.each(function () {
        var filterElement = $(this).data("filter");
        var count = $(".filter-layout").find(filterElement).length;
        $(this)
          .children(".filter-text")
          .append('<span class="count">' + count + "</span>");
      });
    }
  }













  function SmoothMenuScroll() {
    var anchor = $(".scrollToLink");
    if (anchor.length) {
      anchor.children("a").bind("click", function (event) {
        if ($(window).scrollTop() > 10) {
          var headerH = "90";
        } else {
          var headerH = "90";
        }
        var target = $(this);
        $("html, body")
          .stop()
          .animate({
              scrollTop: $(target.attr("href")).offset().top - headerH + "px"
            },
            200,
            "easeInOutExpo"
          );
        anchor.removeClass("current");
        anchor.removeClass("current-menu-ancestor");
        anchor.removeClass("current_page_item");
        anchor.removeClass("current-menu-parent");
        target.parent().addClass("current");
        event.preventDefault();
      });
    }
  }
  SmoothMenuScroll();

  function OnePageMenuScroll() {
    var windscroll = $(window).scrollTop();
    if (windscroll >= 117) {
      var menuAnchor = $(".one-page-scroll-menu .scrollToLink").children("a");
      menuAnchor.each(function () {
        var sections = $(this).attr("href");
        $(sections).each(function () {
          if ($(this).offset().top <= windscroll + 100) {
            var Sectionid = $(sections).attr("id");
            $(".one-page-scroll-menu").find("li").removeClass("current");
            $(".one-page-scroll-menu").find("li").removeClass("current-menu-ancestor");
            $(".one-page-scroll-menu").find("li").removeClass("current_page_item");
            $(".one-page-scroll-menu").find("li").removeClass("current-menu-parent");
            $(".one-page-scroll-menu")
              .find("a[href*=\\#" + Sectionid + "]")
              .parent()
              .addClass("current");
          }
        });
      });
    } else {
      $(".one-page-scroll-menu li.current").removeClass("current");
      $(".one-page-scroll-menu li:first").addClass("current");
    }
  }






  /*-- Handle Scrollbar --*/
  function handleScrollbar() {
    const bodyHeight = $("body").height();
    const scrollPos = $(window).innerHeight() + $(window).scrollTop();
    let percentage = (scrollPos / bodyHeight) * 100;
    if (percentage > 100) {
      percentage = 100;
    }
    $(".scroll-to-top .scroll-to-top__inner").css("width", percentage + "%");
  }




  // Animation gsap 
  function title_animation() {
    var tg_var = jQuery('.sec-title-animation');
    if (!tg_var.length) {
      return;
    }
    const quotes = document.querySelectorAll(".sec-title-animation .title-animation");

    quotes.forEach(quote => {

      //Reset if needed
      if (quote.animation) {
        quote.animation.progress(1).kill();
        quote.split.revert();
      }

      var getclass = quote.closest('.sec-title-animation').className;
      var animation = getclass.split('animation-');
      if (animation[1] == "style4") return

      quote.split = new SplitText(quote, {
        type: "lines,words,chars",
        linesClass: "split-line"
      });
      gsap.set(quote, {
        perspective: 400
      });

      if (animation[1] == "style1") {
        gsap.set(quote.split.chars, {
          opacity: 0,
          y: "90%",
          rotateX: "-40deg"
        });
      }
      if (animation[1] == "style2") {
        gsap.set(quote.split.chars, {
          opacity: 0,
          x: "50"
        });
      }
      if (animation[1] == "style3") {
        gsap.set(quote.split.chars, {
          opacity: 0,
        });
      }
      quote.animation = gsap.to(quote.split.chars, {
        scrollTrigger: {
          trigger: quote,
          start: "top 90%",
        },
        x: "0",
        y: "0",
        rotateX: "0",
        opacity: 1,
        duration: 1,
        ease: Back.easeOut,
        stagger: .02
      });
    });
  }
  ScrollTrigger.addEventListener("refresh", title_animation);






  // ===Price Filter===
  function priceFilter() {
    if ($(".price-ranger").length) {
      $(".price-ranger #slider-range").slider({
        range: true,
        min: 0,
        max: 5000,
        values: [0, 3000],
        slide: function (event, ui) {
          $(".price-ranger .ranger-min-max-block .min").val("" + ui.values[0]);
          $(".price-ranger .ranger-min-max-block .max").val("" + ui.values[1]);
        },
      });
      $(".price-ranger .ranger-min-max-block .min").val(
        "" + $(".price-ranger #slider-range").slider("values", 0)
      );
      $(".price-ranger .ranger-min-max-block .max").val(
        "" + $(".price-ranger #slider-range").slider("values", 1)
      );
    }
  }



  $(".add").on("click", function () {
    if ($(this).prev().val() < 999) {
      $(this)
        .prev()
        .val(+$(this).prev().val() + 1);
    }
  });
  $(".sub").on("click", function () {
    if ($(this).next().val() > 1) {
      if ($(this).next().val() > 1)
        $(this)
        .next()
        .val(+$(this).next().val() - 1);
    }
  });






  // ===Checkout Payment===
  if ($(".checkout__payment__title").length) {
    $(".checkout__payment__item").find(".checkout__payment__content").hide();
    $(".checkout__payment__item--active").find(".checkout__payment__content").show();

    $(".checkout__payment__title").on("click", function (e) {
      e.preventDefault();

      $(this)
        .parents(".checkout__payment")
        .find(".checkout__payment__item")
        .removeClass("checkout__payment__item--active");
      $(this).parents(".checkout__payment").find(".checkout__payment__content").slideUp();

      $(this).parent().addClass("checkout__payment__item--active");
      $(this).parent().find(".checkout__payment__content").slideDown();
    });
  }





  // Product All Tab
  if ($(".product__all-tab").length) {
    $(".product__all-tab .tabs-button-box .tab-btn-item").on("click", function (e) {
      e.preventDefault();
      var target = $($(this).attr("data-tab"));

      if ($(target).hasClass("actve-tab")) {
        return false;
      } else {
        $(".product__all-tab .tabs-button-box .tab-btn-item").removeClass("active-btn-item");
        $(this).addClass("active-btn-item");
        $(".product__all-tab .tabs-content-box .tab-content-box-item").removeClass(
          "tab-content-box-item-active"
        );
        $(target).addClass("tab-content-box-item-active");
      }
    });
  }





  if ($("#shop-details-one__thumb").length) {
    let testimonialsThumb = new Swiper("#shop-details-one__thumb", {
      slidesPerView: 3,
      spaceBetween: 0,
      speed: 1400,
      watchSlidesVisibility: true,
      watchSlidesProgress: true,
      loop: true,
      autoplay: {
        delay: 5000
      }
    });

    let testimonialsCarousel = new Swiper("#shop-details-one__carousel", {
      observer: true,
      observeParents: true,
      loop: true,
      speed: 1400,
      mousewheel: false,
      slidesPerView: 1,
      autoplay: {
        delay: 5000
      },
      thumbs: {
        swiper: testimonialsThumb
      },
      pagination: {
        el: '#testimonials-one__carousel-pagination',
        type: 'bullets',
        clickable: true
      },

      "navigation": {
        "nextEl": "#product-details__swiper-button-next",
        "prevEl": "#product-details__swiper-button-prev"
      },
    });
  }



  //Related Products Carousel
  if ($(".related-products__carousel").length) {
    $(".related-products__carousel").owlCarousel({
      loop: true,
      margin: 30,
      nav: false,
      dots: false,
      smartSpeed: 500,
      autoplay: true,
      autoplayTimeout: 2000,
      navText: [
        '<span class="icon-left-arrow"></span>',
        '<span class="icon-right-arrow"></span>',
      ],
      responsive: {
        0: {
          items: 1,
        },
        768: {
          items: 2,
        },
        992: {
          items: 3,
        },
        1200: {
          items: 3,
        },
        1320: {
          items: 4,
        },
      },
    });
  }






  if ($("#testimonial-three__thumb").length) {
    let testimonialsThumb = new Swiper("#testimonial-three__thumb", {
      slidesPerView: 3,
      spaceBetween: 0,
      speed: 1400,
      watchSlidesVisibility: true,
      watchSlidesProgress: true,
      slideToClickedSlide: true,
      loopedSlides: 4,
      direction: 'vertical',
      loop: true,
      autoplay: {
        delay: 5000
      },
      breakpoints: {
        0: {
          slidesPerView: 3,
          spaceBetween: 0
        },
        575: {
          slidesPerView: 3,
          spaceBetween: 0
        },
        768: {
          slidesPerView: 3,
          spaceBetween: 0
        },

      }
    });

    let testimonialsCarousel = new Swiper("#testimonial-three__carousel", {
      observer: true,
      observeParents: true,
      loop: true,
      speed: 1400,
      mousewheel: false,
      slidesPerView: 1,
      spaceBetween: 72,
      autoplay: {
        delay: 5000
      },
      thumbs: {
        swiper: testimonialsThumb
      },
      pagination: {
        el: "#testimonial-three__carousel-pagination",
        type: "bullets",
        clickable: true
      },

      navigation: {
        nextEl: "#testimonial-three__swiper-button-next",
        prevEl: "#testimonial-three__swiper-button-prev"
      }
    });
  }










  // window load event
  $(window).on("load", function () {


    projectMasonaryLayout();
    fullHeight();
    title_animation();
    priceFilter();
    thmSwiperInit();








    if ($(".post-filter").length) {
      var postFilterList = $(".post-filter li");
      // for first init
      $(".filter-layout").isotope({
        filter: ".filter-item",
        animationOptions: {
          duration: 500,
          easing: "linear",
          queue: false
        }
      });
      // on click filter links
      postFilterList.on("click", function () {
        var Self = $(this);
        var selector = Self.attr("data-filter");
        postFilterList.removeClass("active");
        Self.addClass("active");

        $(".filter-layout").isotope({
          filter: selector,
          animationOptions: {
            duration: 500,
            easing: "linear",
            queue: false
          }
        });
        return false;
      });
    }

    if ($(".post-filter.has-dynamic-filter-counter").length) {
      // var allItem = $('.single-filter-item').length;

      var activeFilterItem = $(".post-filter.has-dynamic-filter-counter").find(
        "li"
      );

      activeFilterItem.each(function () {
        var filterElement = $(this).data("filter");
        var count = $(".filter-layout").find(filterElement).length;
        $(this).append("<sup>[" + count + "]</sup>");
      });
    }








    if ($(".circle-progress").length) {
      $(".circle-progress").appear(function () {
        let circleProgress = $(".circle-progress");
        circleProgress.each(function () {
          let progress = $(this);
          let progressOptions = progress.data("options");
          progress.circleProgress(progressOptions);
        });
      });
    }













  });




  // window scroll event

  $(window).on("scroll", function () {
    if ($(".stricked-menu").length) {
      var headerScrollPos = 300;
      var stricky = $(".stricked-menu");
      if ($(window).scrollTop() > headerScrollPos) {
        stricky.addClass("stricky-fixed");
      } else if ($(this).scrollTop() <= headerScrollPos) {
        stricky.removeClass("stricky-fixed");
      }
    }

    OnePageMenuScroll();

  });

  $(window).on("scroll", function () {
    handleScrollbar();
    if ($(".sticky-header--one-page").length) {
      var headerScrollPos = 130;
      var stricky = $(".sticky-header--one-page");
      if ($(window).scrollTop() > headerScrollPos) {
        stricky.addClass("active");
      } else if ($(this).scrollTop() <= headerScrollPos) {
        stricky.removeClass("active");
      }
    }

    var scrollToTopBtn = ".scroll-to-top";
    if (scrollToTopBtn.length) {
      if ($(window).scrollTop() > 500) {
        $(scrollToTopBtn).addClass("show");
      } else {
        $(scrollToTopBtn).removeClass("show");
      }
    }
  });




  if ($(".before-after-twentytwenty").length) {
    $(".before-after-twentytwenty").each(function () {
      var Self = $(this);
      var objName = Self.attr("id");
      $("#" + objName).twentytwenty();

      // hack for bs tab
      $(document).on("shown.bs.tab", 'a[data-toggle="tab"]', function (e) {
        var paneTarget = $(e.target).attr("data-target");
        var $thePane = $(".tab-pane" + paneTarget);
        var twentyTwentyContainer = "#" + objName;
        var twentyTwentyHeight = $thePane.find(twentyTwentyContainer).height();
        if (0 === twentyTwentyHeight) {
          $thePane.find(twentyTwentyContainer).trigger("resize");
        }
      });
    });
  }


  $('select:not(.ignore)').niceSelect();











})(jQuery);

                 document.addEventListener('DOMContentLoaded', function() {
                     // Initialize Bootstrap carousel with enhanced auto-loop
                     var carouselElement = document.querySelector('#mainCarousel');
                     var carousel = new bootstrap.Carousel(carouselElement, {
                         interval: 5000,        // 5 seconds for faster auto-loop
                         ride: 'carousel',      // Auto-start immediately
                         pause: 'hover',        // Pause on hover, resume on mouse leave
                         wrap: true,            // Continuous loop (goes to first slide after last)
                         keyboard: true,        // Enable keyboard navigation
                         touch: true            // Enable touch/swipe on mobile
                     });
                     
                     // Ensure carousel starts cycling immediately
                     carousel.cycle();
                     
                     // Optional: Restart cycling after user interaction
                     carouselElement.addEventListener('slid.bs.carousel', function() {
                         carousel.cycle();
                     });
                 });

                   
         // Package details data
         const packageDetails = {
             'north-goa': {
                 title: 'North Goa Beach Tour',
                 price: '₹2500',
                 duration: 'Full Day (8-10 hours)',
                 vehicle: 'AC Swift Dzire/Ertiga',
                 inclusions: [
                     'Pickup and drop from hotel',
                     'AC vehicle with fuel',
                     'Experienced driver',
                     'Parking charges',
                     'Toll charges'
                 ],
                 itinerary: [
                     'Fort Aguada (9:00 AM)',
                     'Calangute Beach (10:30 AM)',
                     'Baga Beach (11:30 AM)',
                     'Lunch break (1:00 PM)',
                     'Candolim Beach (3:00 PM)',
                     'Saturday Night Market (5:00 PM)',
                     'Anjuna Beach sunset (6:30 PM)'
                 ],
                 highlights: [
                     'Visit 4 famous North Goa beaches',
                     'Explore historic Fort Aguada',
                     'Shopping at local markets',
                     'Beach activities and water sports',
                     'Scenic coastal drive'
                 ]
             },
             'south-goa': {
                 title: 'South Goa Heritage Tour',
                 price: '₹3000',
                 duration: 'Full Day (9-11 hours)',
                 vehicle: 'AC Swift Dzire/Ertiga',
                 inclusions: [
                     'Pickup and drop from hotel',
                     'AC vehicle with fuel',
                     'Professional guide',
                     'Entry fees to monuments',
                     'Traditional Goan lunch'
                 ],
                 itinerary: [
                     'Basilica of Bom Jesus (9:00 AM)',
                     'Se Cathedral (10:00 AM)',
                     'Archaeological Museum (11:00 AM)',
                     'Spice Plantation visit (12:30 PM)',
                     'Traditional lunch (1:30 PM)',
                     'Margao city tour (3:30 PM)',
                     'Colva Beach (5:00 PM)',
                     'Benaulim Beach sunset (6:30 PM)'
                 ],
                 highlights: [
                     'UNESCO World Heritage sites',
                     'Authentic spice plantation experience',
                     'Traditional Goan cuisine',
                     'Portuguese colonial architecture',
                     'Peaceful South Goa beaches'
                 ]
             },
             'dudhsagar': {
                 title: 'Dudhsagar Waterfall Tour',
                 price: '₹4500',
                 duration: 'Full Day (12-14 hours)',
                 vehicle: 'AC Innova Crysta',
                 inclusions: [
                     'Pickup and drop from hotel',
                     'AC vehicle for entire journey',
                     'Jeep safari to waterfall',
                     'Spice plantation visit',
                     'Buffet lunch at plantation',
                     'Guide services'
                 ],
                 itinerary: [
                     'Early morning pickup (6:00 AM)',
                     'Drive to Mollem (8:30 AM)',
                     'Jeep safari to Dudhsagar (9:30 AM)',
                     'Waterfall visit and swimming (10:30 AM)',
                     'Return journey (1:00 PM)',
                     'Spice plantation visit (2:30 PM)',
                     'Traditional lunch (3:30 PM)',
                     'Return to hotel (7:00 PM)'
                 ],
                 highlights: [
                     'India\'s 5th tallest waterfall',
                     'Thrilling jeep safari through jungle',
                     'Swimming in natural pools',
                     'Authentic spice plantation tour',
                     'Wildlife spotting opportunities'
                 ]
             },
             'complete-goa': {
                 title: 'Complete Goa Tour (3 Days)',
                 price: '₹8999',
                 duration: '3 Days / 2 Nights',
                 vehicle: 'AC Swift Dzire/Ertiga',
                 inclusions: [
                     'Airport pickup and drop',
                     'AC vehicle for 3 days',
                     'Professional driver cum guide',
                     '2 nights accommodation',
                     'Daily breakfast',
                     'All sightseeing as per itinerary'
                 ],
                 itinerary: [
                     'Day 1: Airport pickup, North Goa beaches, hotel check-in',
                     'Day 2: South Goa heritage tour, churches, spice plantation',
                     'Day 3: Dudhsagar waterfall, shopping, airport drop'
                 ],
                 highlights: [
                     'Complete Goa experience in 3 days',
                     'Cover all major attractions',
                     'Comfortable accommodation',
                     'Professional guidance',
                     'Hassle-free travel'
                 ]
             },
             'airport-transfer': {
                 title: 'Airport Transfer Package',
                 price: '₹800',
                 duration: 'One Way (1-2 hours)',
                 vehicle: 'AC Swift Dzire/Ertiga',
                 inclusions: [
                     'Meet and greet service',
                     'Flight tracking',
                     'Free waiting time (45 minutes)',
                     'AC vehicle',
                     'Experienced driver',
                     'All tolls and parking'
                 ],
                 itinerary: [
                     'Driver tracking your flight',
                     'Meet at arrival hall with name board',
                     'Assist with luggage',
                     'Direct transfer to destination',
                     'Payment on arrival'
                 ],
                 highlights: [
                     '24/7 availability',
                     'Flight delay tracking',
                     'Professional drivers',
                     'Clean and comfortable vehicles',
                     'Fixed rate pricing'
                 ]
             },
             'outstation': {
                 title: 'Outstation Tour Package',
                 price: '₹12/km',
                 duration: 'As per requirement',
                 vehicle: 'AC Swift Dzire/Ertiga/Innova',
                 inclusions: [
                     'AC vehicle with fuel',
                     'Experienced driver',
                     'Driver allowance',
                     'Toll and parking charges',
                     '24/7 roadside assistance'
                 ],
                 itinerary: [
                     'Popular destinations: Mumbai (470 km)',
                     'Pune (450 km)',
                     'Bangalore (560 km)',
                     'Mangalore (350 km)',
                     'Custom routes available'
                 ],
                 highlights: [
                     'Comfortable long distance travel',
                     'Flexible timing',
                     'Professional drivers',
                     'Multiple vehicle options',
                     'Transparent pricing'
                 ]
             },
             'wedding': {
                 title: 'Wedding Car Package',
                 price: '₹5999',
                 duration: 'Full Day (12 hours)',
                 vehicle: 'Decorated luxury cars',
                 inclusions: [
                     'Luxury car decoration',
                     'Bridal car with flowers',
                     'Multiple trips for guests',
                     'Professional chauffeur',
                     'Photography assistance',
                     'Coordination support'
                 ],
                 itinerary: [
                     'Bride\'s home pickup',
                     'Venue transportation',
                     'Photo session support',
                     'Guest transportation',
                     'Reception transfer',
                     'End of event drop'
                 ],
                 highlights: [
                     'Beautifully decorated vehicles',
                     'Special bridal treatment',
                     'Multiple vehicle options',
                     'Professional service',
                     'Memorable experience'
                 ]
             },
             'corporate': {
                 title: 'Corporate Package',
                 price: '₹15000/month',
                 duration: 'Monthly basis',
                 vehicle: 'Fleet of AC vehicles',
                 inclusions: [
                     'Dedicated vehicle pool',
                     'Priority booking',
                     'Corporate billing',
                     'Monthly invoicing',
                     '24/7 availability',
                     'Account manager'
                 ],
                 itinerary: [
                     'Employee pickup/drop',
                     'Client meeting transfers',
                     'Airport transfers',
                     'Outstation business trips',
                     'Event transportation'
                 ],
                 highlights: [
                     'Cost-effective solution',
                     'Professional service',
                     'Reliable transportation',
                     'Flexible arrangements',
                     'Business-focused service'
                 ]
             }
         };

         // Package details modal functionality
         document.addEventListener('DOMContentLoaded', function() {
             const packageDetailsBtns = document.querySelectorAll('.package-details-btn');
             const packageDetailsModal = new bootstrap.Modal(document.getElementById('packageDetailsModal'));
             const packageDetailsContent = document.getElementById('packageDetailsContent');
             const packageDetailsModalLabel = document.getElementById('packageDetailsModalLabel');

             packageDetailsBtns.forEach(btn => {
                 btn.addEventListener('click', function(e) {
                     e.preventDefault();
                     const packageType = this.getAttribute('data-package');
                     const packageData = packageDetails[packageType];

                     if (packageData) {
                         packageDetailsModalLabel.textContent = packageData.title;
                         
                         packageDetailsContent.innerHTML = `
                             <div class="row">
                                 <div class="col-md-6">
                                     <div class="package-info">
                                         <h6 style="color: #ff6b35; margin-bottom: 15px;"><i class="fas fa-info-circle"></i> Package Information</h6>
                                         <p><strong>Price:</strong> ${packageData.price}</p>
                                         <p><strong>Duration:</strong> ${packageData.duration}</p>
                                         <p><strong>Vehicle:</strong> ${packageData.vehicle}</p>
                                     </div>
                                     
                                     <div class="package-inclusions">
                                         <h6 style="color: #ff6b35; margin-bottom: 15px;"><i class="fas fa-check-circle"></i> Package Inclusions</h6>
                                         <ul style="list-style: none; padding: 0;">
                                             ${packageData.inclusions.map(item => `<li style="margin-bottom: 8px;"><i class="fas fa-check" style="color: #28a745; margin-right: 8px;"></i>${item}</li>`).join('')}
                                         </ul>
                                     </div>
                                 </div>
                                 
                                 <div class="col-md-6">
                                     <div class="package-itinerary">
                                         <h6 style="color: #ff6b35; margin-bottom: 15px;"><i class="fas fa-route"></i> Itinerary</h6>
                                         <ul style="list-style: none; padding: 0;">
                                             ${packageData.itinerary.map(item => `<li style="margin-bottom: 8px;"><i class="fas fa-map-marker-alt" style="color: #ff6b35; margin-right: 8px;"></i>${item}</li>`).join('')}
                                         </ul>
                                     </div>
                                     
                                     <div class="package-highlights">
                                         <h6 style="color: #ff6b35; margin-bottom: 15px;"><i class="fas fa-star"></i> Highlights</h6>
                                         <ul style="list-style: none; padding: 0;">
                                             ${packageData.highlights.map(item => `<li style="margin-bottom: 8px;"><i class="fas fa-star" style="color: #ffc107; margin-right: 8px;"></i>${item}</li>`).join('')}
                                         </ul>
                                     </div>
                                 </div>
                             </div>
                             
                             <div class="row mt-4">
                                 <div class="col-12">
                                     <div class="alert alert-info" style="background: #e8f4f8; border: 1px solid #bee5eb; color: #0c5460;">
                                         <i class="fas fa-phone"></i> <strong>Book Now:</strong> Call +91 93071 78054 or WhatsApp for instant booking and customization.
                                     </div>
                                 </div>
                             </div>
                         `;
                         
                         packageDetailsModal.show();
                     }
                 });
             });
         });
     
         
         // Service Details Data
         const serviceDetails = {
             'airport': {
                 title: 'Airport Pick up and Drop',
                 description: `Professional airport pickup and drop service available 24/7. Comfortable vehicles with experienced drivers for hassle-free travel.
                 
                 <strong>Key Features:</strong>
                 • 24/7 availability for all flights
                 • Meet & greet service at arrivals
                 • Flight tracking for delays
                 • Professional uniformed drivers
                 • Clean and comfortable vehicles
                 • Fixed pricing - no surge charges
                 • Complimentary waiting time: 30 minutes
                 • Child seats available on request
                 
                 <strong>Coverage:</strong>
                 • Goa International Airport (Dabolim)
                 • All hotels and resorts in North & South Goa
                 • Railway stations and bus terminals
                 • Private residences and guest houses
                 
                 <strong>Pricing:</strong>
                 Starting from ₹800 depending on distance and vehicle type.`
             },
             'railway': {
                 title: 'Railway Station Pick up and Drop',
                 description: `Reliable railway station pickup and drop service. Comfortable vehicles for smooth transfers from all major railway stations.
                 
                 <strong>Key Features:</strong>
                 • Coverage of all major railway stations
                 • Train schedule tracking
                 • Punctual pickup and drop service
                 • Luggage assistance provided
                 • Safe and secure transportation
                 • Experienced local drivers
                 • 24/7 service availability
                 • Affordable fixed rates
                 
                 <strong>Railway Stations Covered:</strong>
                 • Margao Railway Station (South Goa)
                 • Thivim Railway Station (North Goa)
                 • Vasco da Gama Railway Station
                 • Karmali Railway Station
                 • Canacona Railway Station
                 
                 <strong>Pricing:</strong>
                 Starting from ₹500 depending on distance and railway station.`
             },
             'south-goa': {
                 title: 'South Goa Tour',
                 description: `Explore South Goa's beautiful beaches, churches, spice gardens and cultural heritage sites with our experienced drivers.
                 
                 <strong>Popular Attractions:</strong>
                 • Colva Beach & Benaulim Beach
                 • Basilica of Bom Jesus (UNESCO World Heritage Site)
                 • Se Cathedral - one of Asia's largest churches
                 • Cabo de Rama Fort with stunning views
                 • Palolem Beach - pristine and scenic
                 • Tropical Spice Plantation tours
                 • Dona Paula viewpoint
                 • Old Goa heritage sites
                 
                 <strong>Tour Inclusions:</strong>
                 • Experienced local guide/driver
                 • Air-conditioned vehicle
                 • Flexible itinerary planning
                 • Multiple stops and photo opportunities
                 • Cultural insights and historical information
                 • Lunch recommendations at local restaurants
                 
                 <strong>Duration & Pricing:</strong>
                 8-10 hours tour starting from ₹3000 (vehicle + driver).`
             },
             'north-goa': {
                 title: 'North Goa Tour',
                 description: `Discover North Goa's vibrant beaches, bustling markets, historic forts and famous nightlife destinations.
                 
                 <strong>Popular Attractions:</strong>
                 • Baga Beach & Calangute Beach
                 • Chapora Fort (Dil Chahta Hai fort)
                 • Anjuna Beach & Wednesday Flea Market
                 • Arambol Beach - hippie paradise
                 • Fort Aguada - 17th century Portuguese fort
                 • Mapusa Friday Market
                 • Vagator Beach with red cliffs
                 • Candolim Beach - water sports hub
                 
                 <strong>Tour Highlights:</strong>
                 • Beach hopping experience
                 • Historical fort visits
                 • Local market exploration
                 • Water sports activities (optional)
                 • Sunset viewing points
                 • Local Goan cuisine tasting
                 • Shopping at local markets
                 
                 <strong>Duration & Pricing:</strong>
                 8-10 hours tour starting from ₹2500 (vehicle + driver).`
             },
             'dudhsagar': {
                 title: 'Dudhsagar Tour',
                 description: `Experience the majestic Dudhsagar Waterfall, one of India's tallest waterfalls, with safe and comfortable transportation.
                 
                 <strong>About Dudhsagar:</strong>
                 • One of India's tallest waterfalls (310 meters)
                 • Located on Mandovi River
                 • Spectacular four-tiered waterfall
                 • Best visited during monsoon season
                 • Scenic train route passes through the falls
                 • Rich biodiversity in surrounding forest
                 
                 <strong>Tour Options:</strong>
                 • Jeep safari to the waterfall base
                 • Trekking options for adventure enthusiasts
                 • Train spotting at the waterfall
                 • Photography sessions
                 • Nature walks in the forest
                 • Spice plantation visit en route
                 
                 <strong>What's Included:</strong>
                 • Transportation to Dudhsagar base
                 • Jeep safari arrangement
                 • Forest entry permits
                 • Experienced guide
                 • Safety equipment
                 
                 <strong>Pricing:</strong>
                 Full day tour starting from ₹4500 (including jeep safari).`
             },
             'outstation': {
                 title: 'Outstation Cab Service',
                 description: `Long distance travel to Mumbai, Pune, Bangalore with comfortable AC vehicles. Flat rates available for outstation journeys.
                 
                 <strong>Popular Destinations:</strong>
                 • Mumbai - 8-10 hours drive
                 • Pune - 6-8 hours drive
                 • Bangalore - 8-10 hours drive
                 • Belgaum - 3-4 hours drive
                 • Hubli - 4-5 hours drive
                 • Kolhapur - 4-5 hours drive
                 • Hampi - 5-6 hours drive
                 
                 <strong>Service Features:</strong>
                 • Professional experienced drivers
                 • Well-maintained AC vehicles
                 • Multiple vehicle options available
                 • 24/7 roadside assistance
                 • Flexible pickup and drop timings
                 • Fuel and toll charges included
                 • Driver allowance included
                 • GPS tracking for safety
                 
                 <strong>Vehicle Options:</strong>
                 • Swift Dzire: ₹12/km + driver allowance
                 • Ertiga: ₹15/km + driver allowance  
                 • Innova Crysta: ₹18/km + driver allowance
                 
                 <strong>Booking:</strong>
                 Minimum 2 days advance booking recommended.`
             },
             'local-taxi': {
                 title: 'Local Taxi Service',
                 description: `Point to point taxi service within Goa. Swift Dzire ₹12/km, Ertiga ₹15/km, Innova Crysta ₹18/km with transparent pricing.
                 
                 <strong>Service Coverage:</strong>
                 • All areas in North and South Goa
                 • Hotels, resorts, and beaches
                 • Shopping malls and markets
                 • Restaurants and nightlife spots
                 • Tourist attractions and monuments
                 • Residential areas and apartments
                 • Business districts and offices
                 
                 <strong>Vehicle Fleet:</strong>
                 • Swift Dzire: Compact sedan, AC, 4 passengers - ₹12/km
                 • Ertiga: SUV, AC, 6 passengers - ₹15/km
                 • Innova Crysta: Premium MPV, AC, 7 passengers - ₹18/km
                 
                 <strong>Service Features:</strong>
                 • Transparent kilometer-based pricing
                 • No hidden charges or surge pricing
                 • Professional trained drivers
                 • Clean and well-maintained vehicles
                 • GPS-enabled for accurate distance
                 • 24/7 availability
                 • Quick response time
                 • Safe and reliable service
                 
                 <strong>Booking:</strong>
                 Instant booking available. Minimum charge: ₹100.`
             }
         };

         document.addEventListener('DOMContentLoaded', function() {
             // Read More functionality
             document.querySelectorAll('.service-read-more').forEach(button => {
                 button.addEventListener('click', function(e) {
                     e.preventDefault();
                     const serviceKey = this.getAttribute('data-service');
                     const serviceData = serviceDetails[serviceKey];
                     const textElement = this.closest('.services-one__content').querySelector('.services-one__text');
                     
                     if (this.textContent === 'Read More') {
                         textElement.innerHTML = serviceData.description;
                         this.textContent = 'Read Less';
                         this.style.background = '#ff6b35';
                         this.style.color = '#fff';
                     } else {
                         // Reset to original short description
                         const originalTexts = {
                             'airport': 'Professional airport pickup and drop service available 24/7. Comfortable vehicles with experienced drivers for hassle-free travel.',
                             'railway': 'Reliable railway station pickup and drop service. Comfortable vehicles for smooth transfers from all major railway stations.',
                             'south-goa': 'Explore South Goa\'s beautiful beaches, churches, spice gardens and cultural heritage sites with our experienced drivers.',
                             'north-goa': 'Discover North Goa\'s vibrant beaches, bustling markets, historic forts and famous nightlife destinations.',
                             'dudhsagar': 'Experience the majestic Dudhsagar Waterfall, one of India\'s tallest waterfalls, with safe and comfortable transportation.',
                             'outstation': 'Long distance travel to Mumbai, Pune, Bangalore with comfortable AC vehicles. Flat rates available for outstation journeys.',
                             'local-taxi': 'Point to point taxi service within Goa. Swift Dzire ₹12/km, Ertiga ₹15/km, Innova Crysta ₹18/km with transparent pricing.'
                         };
                         textElement.innerHTML = originalTexts[serviceKey];
                         this.textContent = 'Read More';
                         this.style.background = '';
                         this.style.color = '#666';
                     }
                 });
             });

             // Book Now functionality - pre-select service
             document.querySelectorAll('.service-book-now').forEach(button => {
                 button.addEventListener('click', function(e) {
                     const serviceType = this.getAttribute('data-service');
                     setTimeout(() => {
                         document.getElementById('serviceType').value = serviceType;
                     }, 100);
                 });
             });

             // Set minimum date to today for booking
             const dateInput = document.getElementById('bookingDate');
             if (dateInput) {
                 const today = new Date().toISOString().split('T')[0];
                 dateInput.setAttribute('min', today);
             }
             
             // Form submission handler
             const bookingForm = document.getElementById('bookingForm');
             if (bookingForm) {
                 bookingForm.addEventListener('submit', function(e) {
                     e.preventDefault();
                     
                     const formData = new FormData(this);
                     const data = Object.fromEntries(formData);
                     
                     const message = `🚕 *New Taxi Booking Request*\n\n` +
                         `👤 *Customer Details:*\n` +
                         `Name: ${data.name}\n` +
                         `Phone: ${data.phone}\n` +
                         `Email: ${data.email || 'Not provided'}\n\n` +
                         `🚗 *Service Details:*\n` +
                         `Service: ${data.service}\n` +
                         `Pickup: ${data.pickup}\n` +
                         `Drop: ${data.drop || 'Not specified'}\n` +
                         `Date: ${data.date}\n` +
                         `Time: ${data.time}\n` +
                         `Passengers: ${data.passengers || '1'}\n` +
                         `Vehicle: ${data.vehicle || 'Any'}\n\n` +
                         `📝 *Special Requests:*\n` +
                         `${data.message || 'None'}\n\n` +
                         `Please confirm this booking. Thank you!`;
                     
                     const whatsappUrl = `https://wa.me/919307178054?text=${encodeURIComponent(message)}`;
                     
                     const resultDiv = document.querySelector('.result');
                     resultDiv.innerHTML = `
                         <div class="alert alert-success" style="margin-top: 15px; padding: 15px; background: #d4edda; border: 1px solid #c3e6cb; border-radius: 6px; color: #155724;">
                             <i class="fas fa-check-circle" style="margin-right: 8px;"></i>
                             Redirecting to WhatsApp for confirmation...
                         </div>
                     `;
                     
                     setTimeout(() => {
                         window.open(whatsappUrl, '_blank');
                         setTimeout(() => {
                             const modal = bootstrap.Modal.getInstance(document.getElementById('bookingModal'));
                             modal.hide();
                             bookingForm.reset();
                             resultDiv.innerHTML = '';
                         }, 1000);
                     }, 1500);
                 });
             }
         });
     
        // Add scroll animation for elements
        document.addEventListener('DOMContentLoaded', function() {
            // Add hover effect to service list items
            const serviceItems = document.querySelectorAll('.service-details__services-list li');
            
            serviceItems.forEach(item => {
                item.addEventListener('mouseenter', function() {
                    if (!this.classList.contains('active')) {
                        this.style.transform = 'translateX(5px)';
                    }
                });
                
                item.addEventListener('mouseleave', function() {
                    if (!this.classList.contains('active')) {
                        this.style.transform = 'translateX(0)';
                    }
                });
            });
            
            // Add animation to contact card on hover
            const contactCard = document.querySelector('.service-details__sidebar-contact');
            
            contactCard.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-5px)';
            });
            
            contactCard.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });